#!/usr/bin/env python
# -*- coding: utf-8 -*-
from utils import *

class View:

    def __init__(self):
        self.cms = 'pages'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self ):
        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        dic.close()


        if scfg.get("PAGEMAKE") == 'HTML':
            pages = GetHtmlMenuPages() 


        return render.pages(    
                                cms = self.cms,                        
                                scfg = scfg, 
                                pages = pages,
                                mode = 'view',
                                id = None,
                                html_file = None,
        )

class Edit:

    def __init__(self):
        self.cms = 'pages'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self, id='index' ):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        dic.close()

        try:
            file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"r","utf8")
            html_file=file.read()
            file.close()
        except:
            shutil.copyfile(PANEO_CMS_PAGE_TEMPLATES_DIR+pages[id].get('TEMPLATE')+'.html', PANEO_SITE_DATA_DIR+id+'.html')

        file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"r","utf8")
        html_file=file.read()
        file.close()

        templates = {}
        tmps = glob.glob( PANEO_CMS_PAGE_TEMPLATES_DIR + '*.html')
        n = 0
        for f in tmps:
            fname = os.path.split(f)[1]
            name, ext = os.path.splitext(fname)
            templates[name] = n 
            n = n + 1

        page_img = {} 
        for ii in range(1,4):
            file = 'page_%s_img%s_file' % ( id , ii )
            if IMG_CONV :
                src = "/img/page_%s_img%s" % ( id , ii )
            else:
                src = "/%s/img/page_%s_img%s" % ( PANEO_SITE_DIR , id , ii )
            page_img[file] = [ os.path.exists(PANEO_SITE_DATA_DIR + "img/page_%s_img%s" % (id,ii)) , src ]

        return render.pages(     
                                cms = self.cms,                        
                                mode = 'edit',
                                id = id,
                                scfg = scfg, 
                                pages = pages,
                                html_file = html_file,
                                templates = templates,
                                page_img = page_img
        )


    def POST( self, id=None ):

        if id is None:
            return web.notfound()

        i = web.input(  IDX=0,
                        TYPE='MENU',
                        PARENT='',
                        LINK='',
                        FILENAME='index' )

        #値のチェック
        web.ctx.MSG = u""
        reg = re.compile(r'^[0-9A-Za-z]+$')
        r = reg.search(i.FILENAME.encode('utf8')) 
        if r is None:
            web.ctx.MSG = u"ファイル名は半角英数字のみ有効です。"
            return self.GET( id )

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')

        if i.FILENAME != id :
            if pages.has_key(i.FILENAME):
                web.ctx.MSG = u"%sはすでに利用されています" % i.FILENAME
                dic.close()
                return self.GET(id)

        #TEMPLATEが変更していたら切り替え
        if pages[id].get("TEMPLATE") != i.TEMPLATE :
            shutil.copyfile(PANEO_CMS_PAGE_TEMPLATES_DIR+i.TEMPLATE+'.html', PANEO_SITE_DATA_DIR+id+'.html')
        else:
            file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"w","utf8")
            file.write(i.HTMLTEMPLATE)
            file.close()

        if i.FILENAME != id :
            web.ctx.MSG = u"%sに複製されました。%sが不要な場合は削除してください。" % ( i.FILENAME , id )
            id = i.FILENAME

        #TEMPLATEのバックアップ
        if os.path.exists(PANEO_SITE_DATA_DIR+id+'.html'):
            shutil.copyfile(PANEO_SITE_DATA_DIR+id+'.html',PANEO_SITE_DATA_DIR+'backup/'+id+'.html.'+dt+'.bak')

        #PAGE削除
        if i.has_key("PAGE_DELETE") :
            del pages[id] 
            if os.path.exists(PANEO_SITE_DATA_DIR+id+'.html'):
                os.remove(PANEO_SITE_DATA_DIR+id+'.html')
            dic['pages'] = pages
            dic.close()
            return web.seeother("/paneo/pages/")

        #画像
        img_alt = {}
        for ii in range(1,4):
            if i.has_key('page_%s_img%s_file_del' % (id,ii)):
                if os.path.exists(PANEO_SITE_DATA_DIR + "img/page_%s_img%s" % (id,ii)):
                    os.remove(PANEO_SITE_DATA_DIR + "img/page_%s_img%s" % (id,ii))
            
            f = 'page_%s_img%s_file' % ( id , ii )
            if i.has_key(f):
                if i[f] != "":
                    fout = open(PANEO_SITE_DATA_DIR + "img/page_%s_img%s" % (id,ii),'wb')
                    fout.write(i[f])
                    fout.close()

            alt = 'page_%s_img%s_alt' % (id,ii)
            img_alt[alt] = i[alt]
        
        #PAGEの更新
        pages[id] = {   'IDX':i.IDX,
                        'TYPE':i.TYPE,
                        'PARENT':i.PARENT,
                        'TEMPLATE':i.TEMPLATE,
                        'TITLE':i.TITLE,
                        'LINK':i.LINK,
                        'IMG':img_alt,
        }


        dic['pages'] = pages
        dic.close()

        return self.GET( id )


class New:

    def __init__(self):
        self.cms = 'pages'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self ):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        dic.close()

        tp = glob.glob( PANEO_SITE_DATA_DIR + '*.html')
        tp_ = glob.glob( PANEO_SITE_DATA_DIR + '_*.html')
        tpf_ = glob.glob( PANEO_SITE_DATA_DIR + 'formmail_*.html')

        pnum = len(tp) - len(tp_) - len(tpf_)
        id = 'page%s' % pnum 
        pages[id] = {   'IDX':pnum,
                        'TYPE':'MENU',
                        'TEMPLATE':'blank',
                        'PARENT':'',
                        'TITLE':u'新しいページ%s' % pnum,
                        'LINK':'',
                        'IMG':{},
        }

        templates = {}
        tmps = glob.glob( PANEO_CMS_PAGE_TEMPLATES_DIR + '*.html')
        n = 0
        for f in tmps:
            fname = os.path.split(f)[1]
            name, ext = os.path.splitext(fname)
            templates[name] = n 
            n = n + 1

        return render.pages(  
                                cms = self.cms,                        
                                mode = 'new',
                                id = id,
                                scfg = scfg, 
                                pages = pages,
                                html_file = None,
                                templates = templates,
        )


    def POST( self ):

        i = web.input()

        #値のチェック
        web.ctx.MSG = u""
        if i.FILENAME == 'index':
            web.ctx.MSG = u"新規登録でindexは指定できません。"
            return self.GET()

        reg = re.compile(r'^[0-9A-Za-z]+$')
        r = reg.search(i.FILENAME.encode('utf8')) 
        if r is None:
            web.ctx.MSG = u"ファイル名は半角英数字のみ有効です。"
            return self.GET()

        dic = sqlite3dbm.sshelve.open(PANEO_DB)

        scfg = dic.get('siteconfig')
        pages = dic.get('pages')

        if pages.has_key(i.FILENAME):
            web.ctx.MSG = u"%sはすでに利用されています" % i.FILENAME
            dic.close()
            return self.GET()


        #PAGE追加
        id= i.FILENAME
        pages[id] = {   'IDX':i.IDX,
                        'TYPE':i.TYPE,
                        'PARENT':i.PARENT,
                        'TEMPLATE':i.TEMPLATE,
                        'TITLE':i.TITLE,
                        'LINK':i.LINK,
                        'IMG':{},
        }
        dic['pages'] = pages

        #TEMPLATEのバックアップ
        if os.path.exists(PANEO_SITE_DATA_DIR+id+'.html'):
            shutil.copyfile(PANEO_SITE_DATA_DIR+id+'.html',PANEO_SITE_DATA_DIR+'backup/'+id+'.html.'+dt+'.bak')

        #TEMPLATEのコピー
        shutil.copyfile(PANEO_CMS_PAGE_TEMPLATES_DIR+i.TEMPLATE+'.html', PANEO_SITE_DATA_DIR+id+'.html')

        dic.close()
        
        return web.seeother('http://' + web.ctx.host + '/paneo/pages/edit/%s/' % id)
